﻿//////////////////////////////////////////////
// NodeWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkExportWrap
{
	class DLL_ASTRAEUS_EXPORT NodeWrapper final
	{
		public :

			// Mise en place environnement
			static void updateEnvironment (nkScripts::Environment* env) ;

			// Callbacks qui seront appelés suivant les fonctions
			// Construction / destruction
			static void* constructor (const nkScripts::DataStack& stack) ;
			static void destructor (void* toDestroy) ;
			// Getters
			static nkScripts::OutputValue getValueAsString (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getValueAsInt (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getValueAsFloat (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getValueAsDouble (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getValueAsBool (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getNodeNature (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getNodeValueType (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getArraySize (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue isValueTypeNumber (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getArrayElement (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getMemberCount (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getMemberKey (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getMemberValue (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getMemberValueIndex (const nkScripts::DataStack& stack) ;
			// Setters
			static nkScripts::OutputValue setAsString (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setAsInt (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setAsFloat (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setAsDouble (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setAsBool (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue addElement (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue addMember (const nkScripts::DataStack& stack) ;
	} ;
}